/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <stdio.h>
#include "mp84.h"

int id[4]={0x3FFF,0x3FFF,0x3FFF,0x3FFF};
int conf_to_write,conf_mask;

void read_status()
{
    int t;
    char buf[40];
    
    write_message("Reading configuration...",M_INFO_L);
    set_voltage(NORMAL);
    enter_prog_mode();
    issue_command(LOADCONF);
    write_data(0xFFFF);
    for(t=0;t<7;t++) issue_command(INCREMENT);
    issue_command(READPROG);
    t=read_data();
    leave_prog_mode();
    write_message("done",M_INFO);
    sprintf(buf,"Configuration word is: %04X",t);
    write_message(buf,M_INFO);
    sprintf(buf,"  FDSC:  %02X (oscillator type: ",t&3);
    switch(t&3)
    {
	case 0 : strcat(buf,"LP)"); break;
	case 1 : strcat(buf,"XT)"); break;
	case 2 : strcat(buf,"HS)"); break;
	case 3 : strcat(buf,"RC)"); break;
    }
    write_message(buf,M_INFO);
    sprintf(buf,"  WDTE:  %02X (watchdog timer: ",(t&4)>>2);
    switch((t&4)>>2)
    {
	case 0 : strcat(buf,"disabled)"); break;
	case 1 : strcat(buf,"enabled)"); break;
    }
    write_message(buf,M_INFO);
    sprintf(buf,"  PWRTE: %02X (power up timer: ",(t&8)>>3);
    switch((t&8)>>3)
    {
	case 1 : strcat(buf,"disabled)"); break;
	case 0 : strcat(buf,"enabled)"); break;
    }
    write_message(buf,M_INFO);
    sprintf(buf,"  CP:    %02X (code protection: ",(t&16)>>4);
    switch((t&16)>>4)
    {
	case 1 : strcat(buf,"disabled)"); break;
	case 0 : strcat(buf,"enabled)"); break;
    }
    write_message(buf,M_INFO);
}

void write_status()
{
    int t;
    char buf[40];
    
    write_message("Reading configuration...",M_INFO_L);
    set_voltage(NORMAL);
    enter_prog_mode();
    issue_command(LOADCONF);
    write_data(0xFFFF);
    for(t=0;t<7;t++) issue_command(INCREMENT);
    issue_command(READPROG);
    t=read_data();
    write_message("done",M_INFO);
    t=(t%conf_mask)|conf_to_write;
    write_message("Writing configuration...",M_INFO_L);
    issue_command(LOADPROG);
    write_data(t);
    issue_command(PROGRAM);
    usleep(10000);
    write_message("done",M_INFO);
    leave_prog_mode();
}

void identify_chip()
{
    int tmp;
    char buf[100];

    write_message("Reading ID locations...",M_INFO_L);
    set_voltage(NORMAL);
    enter_prog_mode();
    issue_command(LOADCONF);
    write_data(0xFFFF);
    for(tmp=0;tmp<4;tmp++)
    {
	issue_command(READPROG);
	id[tmp]=read_data();
	issue_command(INCREMENT);
    }
    leave_prog_mode();
    write_message("done",M_INFO);
    sprintf(buf,"ID values: %04X/%04X/%04X/%04X",id[0],id[1],id[2],id[3]);
    write_message(buf,M_INFO);
}

void program_ids()
{
    int tmp;

    write_message("Programming ID locations...",M_INFO_L);
    set_voltage(NORMAL);
    enter_prog_mode();
    issue_command(LOADCONF);
    write_data(0xFFFF);
    for(tmp=0;tmp<4;tmp++)
    {
	issue_command(LOADPROG);
	write_data(id[tmp]);
	issue_command(PROGRAM);
	usleep(10000);
	issue_command(INCREMENT);
    }
    leave_prog_mode();
    write_message("done",M_INFO);
}

void protect_code()
{
    int tmp;

    write_message("Enabling code protection...",M_INFO_L);
    set_voltage(NORMAL);
    enter_prog_mode();
    issue_command(LOADCONF);
    write_data(0xFFFF);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(READPROG);
    tmp=read_data();
    tmp&=0xF;
    issue_command(LOADPROG);
    write_data(tmp);
    issue_command(PROGRAM);
    usleep(10000);
    leave_prog_mode();
    write_message("done",M_INFO);
}

void unprotect_code()
{
    write_message("Disabling code protection...",M_INFO_L);
    set_voltage(NORMAL);
    enter_prog_mode();
    issue_command(LOADCONF);
    write_data(0xFFFF);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(INCREMENT);
    issue_command(UCP1);
    issue_command(UCP2);
    issue_command(PROGRAM);
    usleep(10000);
    issue_command(UCP1);
    issue_command(UCP2);
    leave_prog_mode();
    write_message("done",M_INFO);
}

void program_area(int base,int len,int command,int command2,int mask)
{
    int adr,tmp,ladr;
    char buf[5];
        
    ladr=0;
    for(adr=0;adr<len;adr++)
    {
        if(used_area(adr+base,adr+1+base))
        {
	    sprintf(buf,"%04X",adr);
	    write_message(buf,M_INFO_L);
	    for(tmp=0;tmp<adr-ladr;tmp++) issue_command(INCREMENT);
	    issue_command(command);
	    write_data(words[adr+base]);
	    issue_command(PROGRAM);
	    usleep(10000);
	    issue_command(command2);
	    tmp=read_data();
	    if((tmp&mask)!=(words[adr+base]&mask))
	    {
		putchar('\n');
		write_message("Programming error",M_ERROR);
		panic(2);
	    }
	    ladr=adr;
	    write_message("\b\b\b\b\b\b",M_INFO_L);
	}
    }
}

void verify_area(int base,int len,int command,int mask)
{
    int adr,tmp,ladr;
    char buf[5];
    
    ladr=0;
    for(adr=0;adr<len;adr++)
    {
        if(used_area(adr+base,adr+1+base))
        {
	    sprintf(buf,"%04X",adr);
	    write_message(buf,M_INFO_L);
	    for(tmp=0;tmp<adr-ladr;tmp++) issue_command(INCREMENT);
	    issue_command(command);
	    tmp=read_data();
	    if((tmp&mask)!=(words[adr+base]&mask))
	    {
		putchar('\n');
		write_message("Verification error",M_ERROR);
		panic(2);
	    }
	    ladr=adr;
	    write_message("\b\b\b\b\b\b",M_INFO_L);
	}
    }
}

void read_area(int base,int len,int command)
{
    int adr;
    char buf[5];
    
    for(adr=0;adr<len;adr++)
    {
        sprintf(buf,"%04X",adr);
        write_message(buf,M_INFO_L);
        issue_command(command);
	words[adr+base]=read_data()|0x8000;
	issue_command(INCREMENT);
        write_message("\b\b\b\b\b\b",M_INFO_L);
    }
}

void read_pic()
{
    int a;

    if(program_code)
    {
	write_message("Reading program memory...",M_INFO_L);
	enter_prog_mode();
	read_area(0,0x400,READPROG);
	leave_prog_mode();
	write_message("      ",M_INFO);
    }
    if(program_data)
    {
	write_message("Reading EEPROM memory... ",M_INFO_L);
	enter_prog_mode();
	read_area(0x2100,64,READDATA);
	leave_prog_mode();
	write_message("      ",M_INFO);
    }
    if(program_id)
    {
	write_message("Reading ID locations...  ",M_INFO_L);
	enter_prog_mode();
	issue_command(LOADCONF);
	write_data(0);
	read_area(0x2000,4,READPROG);
	leave_prog_mode();
	write_message("      ",M_INFO);
    }
    if(program_status)
    {
	write_message("Reading status word...   ",M_INFO_L);
	enter_prog_mode();
	issue_command(LOADCONF);
	write_data(0);
	for(a=0;a<7;a++) issue_command(INCREMENT);
	read_area(0x2007,1,READPROG);
	leave_prog_mode();
	write_message("      ",M_INFO);
    }
}


void program_pic()
{
    int a;

    if(hascode&&program_code)
    {
	write_message("Programming program memory: ",M_INFO_L);
	enter_prog_mode();
	write_message("Programming...",M_INFO_L);
	program_area(0,0x400,LOADPROG,READPROG,0x3FFF);
	leave_prog_mode();
	if(!no_verify)
	{
	    write_message("Verifying...",M_INFO_L);
	    set_voltage(HIGH);
	    enter_prog_mode();
	    verify_area(0,0x400,READPROG,0x3FFF);
	    leave_prog_mode();
	    set_voltage(LOW);
	    enter_prog_mode();
	    verify_area(0,0x400,READPROG,0x3FFF);
	    leave_prog_mode();
	    set_voltage(NORMAL);
	}
	write_message("      ",M_INFO);
    }
    if(hasdata&&program_data)
    {
	write_message("Programming EEPROM memory : ",M_INFO_L);
	enter_prog_mode();
	write_message("Programming...",M_INFO_L);
	program_area(0x2100,64,LOADDATA,READDATA,0xFF);
	leave_prog_mode();
	if(!no_verify)
	{
	    write_message("Verifying...",M_INFO_L);
	    set_voltage(HIGH);
	    enter_prog_mode();
	    verify_area(0x2100,64,READDATA,0xFF);
	    leave_prog_mode();
	    set_voltage(LOW);
	    enter_prog_mode();
	    verify_area(0x2100,64,READDATA,0xFF);
	    leave_prog_mode();
	    set_voltage(NORMAL);
	}
	write_message("      ",M_INFO);
    }
    if(hasid&&program_id)
    {
	write_message("Programming ID locations  : ",M_INFO_L);
	enter_prog_mode();
	write_message("Programming...",M_INFO_L);
	issue_command(LOADCONF);
	write_data(0);
	program_area(0x2000,4,LOADPROG,READPROG,0x3FFF);
	leave_prog_mode();
	write_message("      ",M_INFO);
    }
    if(hasstatus&&program_status)
    {
	write_message("Programming status word   : ",M_INFO_L);
	enter_prog_mode();
	write_message("Programming...",M_INFO_L);
	issue_command(LOADCONF);
	write_data(0);
	for(a=0;a<7;a++) issue_command(INCREMENT);
	program_area(0x2007,1,LOADPROG,READPROG,0x3FFF);
	leave_prog_mode();
	if(!no_verify)
	{
	    write_message("Verifying...",M_INFO_L);
	    set_voltage(HIGH);
	    enter_prog_mode();
	    issue_command(LOADCONF);
	    write_data(0);
	    for(a=0;a<7;a++) issue_command(INCREMENT);
	    verify_area(0x2007,1,READPROG,0x3FFF);
	    leave_prog_mode();
	    set_voltage(LOW);
	    enter_prog_mode();
	    issue_command(LOADCONF);
	    write_data(0);
	    for(a=0;a<7;a++) issue_command(INCREMENT);
	    verify_area(0x2007,1,READPROG,0x3FFF);
	    leave_prog_mode();
	    set_voltage(NORMAL);
	}
	write_message("      ",M_INFO);
    }
    if(!hascode&&program_code)   write_message("File does not contain program data",M_WARNING);
    if(!hasdata&&program_data)   write_message("File does not contain EEPROM data",M_WARNING);
    if(!hasid&&program_id)     write_message("File does not contain ID data",M_WARNING);
    if(!hasstatus&&program_status) write_message("File does not contain status word",M_WARNING);
}

void verify_pic()
{
    int a;

    if(hascode&&program_code)
    {
	write_message("Verifying program memory: ",M_INFO_L);
	set_voltage(NORMAL);
	enter_prog_mode();
	verify_area(0,0x400,READPROG,0x3FFF);
	leave_prog_mode();
	set_voltage(HIGH);
	enter_prog_mode();
	verify_area(0,0x400,READPROG,0x3FFF);
	leave_prog_mode();
	set_voltage(LOW);
	enter_prog_mode();
	verify_area(0,0x400,READPROG,0x3FFF);
	leave_prog_mode();
	set_voltage(NORMAL);
	write_message("      ",M_INFO);
    }
    if(hasdata&&program_data)
    {
	write_message("Verifying EEPROM memory : ",M_INFO_L);
	set_voltage(HIGH);
	enter_prog_mode();
	verify_area(0x2100,64,READDATA,0xFF);
	leave_prog_mode();
	set_voltage(LOW);
	enter_prog_mode();
	verify_area(0x2100,64,READDATA,0xFF);
	leave_prog_mode();
	set_voltage(NORMAL);
	write_message("      ",M_INFO);
    }
    if(hasstatus&&program_status)
    {
	write_message("Verifying status word   : ",M_INFO_L);
	set_voltage(NORMAL);
	enter_prog_mode();
	issue_command(LOADCONF);
	write_data(0);
	for(a=0;a<7;a++) issue_command(INCREMENT);
	verify_area(0x2007,1,READPROG,0x3FFF);
	leave_prog_mode();
	set_voltage(HIGH);
	enter_prog_mode();
	issue_command(LOADCONF);
	write_data(0);
	for(a=0;a<7;a++) issue_command(INCREMENT);
	verify_area(0x2007,1,READPROG,0x3FFF);
	leave_prog_mode();
	set_voltage(LOW);
	enter_prog_mode();
	issue_command(LOADCONF);
	write_data(0);
	for(a=0;a<7;a++) issue_command(INCREMENT);
	verify_area(0x2007,1,READPROG,0x3FFF);
	leave_prog_mode();
	set_voltage(NORMAL);
	write_message("      ",M_INFO);
    }
    if(!hascode&&program_code)   write_message("File does not contain program data",M_WARNING);
    if(!hasdata&&program_data)   write_message("File does not contain EEPROM data",M_WARNING);
    if(!hasstatus&&program_status) write_message("File does not contain status word",M_WARNING);
}
