/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "mp84.h"

void parse_config_file(FILE *f)
{
    char buf[200];
    
    while(fgets(buf,199,f)!=NULL)
    {
	if((buf[0]!='#')&&(buf[0]!='\n'))
	{
	    if(!strncmp(buf,"base",4))
	    {
		if(sscanf(buf+4," = %X",&iobase)!=1)
		{
		    write_message("Error in config file",M_ERROR);
		    exit(1);
		}
	    }
	    else
	    {
		write_message("Error in config file",M_ERROR);
		exit(1);
	    }
	}
    }
}

void read_config()
{
    FILE *f;
    char buf[200];
    
    f=fopen("/etc/mp84.conf","r");
    if(f!=NULL)
    {
	parse_config_file(f);
	fclose(f);
    }
    if(getenv("HOME")!=NULL)
    {
	strcpy(buf,getenv("HOME"));
	strcat(buf,"/.mp84rc");
        f=fopen(buf,"r");
	if(f!=NULL)
	{
	    parse_config_file(f);
	    fclose(f);
	}
    }
}
