/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <stdio.h>
#include <string.h>
#include "mp84.h"

int words[0x4000];
int hascode,hasid,hasstatus,hasdata,hasmore;

int hex_number(char *h)
{
    char s[3];
    int n;
    
    s[0]=*h++; s[1]=*h++; s[2]='\0';
    if(sscanf(s,"%02X",&n)!=1) return ERROR; else return n;
}

int check_line(char *l)
{
    int a=0,b;

    l++;
    while(*l!='\0')
    {
	b=hex_number(l);
	if(b==ERROR) return 0;
	a+=b;
	l+=2;
    }
    return !(a&255);
}

int parse_line(FILE *f)
{
    char *buf,*ptr;
    int c,len=0,cnt,tmp,adr,chksum=0;
    
    buf=(char *)calloc(1,1);
    for(;;)
    {
	c=fgetc(f);
	if(c==EOF) return F_EOF;
	if(c=='\n') break;
	buf=(char *)realloc(buf,len+2);
	buf[len++]=(char)c;
	buf[len]='\0';
    }
    if((buf[0]!=':')||(len<11)) return F_ERROR;
    if(!check_line(buf)) return F_ERROR;
    cnt=hex_number(buf+1);
    tmp=hex_number(buf+7);
    if(tmp==1) return F_EOF;
    adr=hex_number(buf+5);
    tmp=hex_number(buf+3);
    adr|=(tmp<<8);
    if(len!=cnt*2+11) return F_ERROR;
    ptr=buf+9;
    cnt>>=1;
    adr>>=1;
    for(tmp=0;tmp<cnt;tmp++,ptr+=4) words[0x3FFF&adr++]=(0x3FFF&((hex_number(ptr+2)<<8)|hex_number(ptr)))|0x8000;
    free(buf);
    return F_CONTINUE;
}

void parse_file(char *name)
{
    FILE *f;
    int tmp;
    
    if((f=fopen(name,"r"))==NULL)
    {
	write_message("Cannot open file",M_ERROR);
	panic(1);
    }
    while((tmp=parse_line(f))==F_CONTINUE);
    fclose(f);
    if(tmp==F_ERROR)
    {
	write_message("Corrupted file",M_ERROR);
	panic(1);
    }
    hascode=used_area(0x0000,0x0400);
    hasid=used_area(0x2000,0x2004);
    hasstatus=used_area(0x2007,0x2008);
    hasdata=used_area(0x2100,0x2140);
    hasmore=used_area(0x0400,0x2000)||used_area(0x2004,0x2007)||used_area(0x2008,0x2100)||used_area(0x2140,0x4000);
    if(hasmore) write_message("File contains extra data which cannot be programmed",M_WARNING);
}

void write_line(FILE *f,int adr,int cnt,int *buf)
{
    int chksum=0,c;

    adr<<=1;
    chksum+=(cnt<<1)+(adr>>8)+(adr&255);
    fprintf(f,":%02X%04X00",cnt<<1,adr);
    for(c=0;c<cnt;c++)
    {
	fprintf(f,"%02X%02X",buf[c]&255,(buf[c]>>8)&0x3F);
	chksum+=(buf[c]&255)+((buf[c]>>8)&0x3F);
    }
    fprintf(f,"%02X\n",(-chksum)&255);
}

void write_file(char *name)
{
    int buf[8],adr;
    FILE *f;
    
    if((f=fopen(name,"w"))==NULL)
    {
	write_message("Cannot open file",M_ERROR);
	panic(1);
    }
    for(adr=0;adr<128;adr++)
    {
	if(used_area(adr,adr+8)) write_line(f,adr<<3,8,words+(adr<<3));
    }
    for(adr=0;adr<4;adr++)
    {
	if(used_area(0x2100+adr,0x2108+adr)) write_line(f,0x2100+(adr<<3),8,words+(0x2100+(adr<<3)));
    }
    if(used_area(0x2000,0x2004)) write_line(f,0x2000,4,words+0x2000);
    if(used_area(0x2007,0x2008)) write_line(f,0x2007,1,words+0x2007);
    fprintf(f,":00000001FF\n");
    fclose(f);
}

