/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <unistd.h>
#include "mp84.h"
#define extern
#include <asm/io.h>

int iobase=0x378;

void small_delay()
{
    int c;
    
    for(c=0;c<50;c++) outb(0,0x80);
}

void set_lpt_bits(int value,int mask)
{
    static int old=0xff;
    
    old&=~mask;
    old|=(value&mask);
    outb_p(old,iobase);
}

void set_voltage(int v)
{
    set_lpt_bits(v,7);
}

void set_pic_bit(int bit,int v)
{
    set_lpt_bits(v?0:bit,bit);
}

int read_pic_data()
{
    unsigned char v;
    
    v=inb_p(iobase+1);
    return (v&0x80)!=0;
}

void enter_prog_mode()
{
    set_pic_bit(MCLR,0);
    set_pic_bit(CLOCK,0);
    set_pic_bit(DATA,0);
    usleep(10000);
    set_pic_bit(MCLR,1);
    usleep(10000);
}

void leave_prog_mode()
{
    set_pic_bit(MCLR,0);
}

void clock_bit(int bit)
{
    set_pic_bit(CLOCK,1);
    set_pic_bit(DATA,bit);
    small_delay();
    set_pic_bit(CLOCK,0);
    small_delay();
}

void seek_for_programmer()
{
    int t=0;

    leave_prog_mode();
    set_voltage(NORMAL);
    set_pic_bit(DATA,0);
    small_delay();
    t=read_pic_data()<<1;
    set_pic_bit(DATA,1);
    small_delay();
    t|=read_pic_data();
    if(t!=1)
    {
	write_message("Programmer not found",M_ERROR);
	panic(2);
    }
}

void issue_command(int cmd)
{
    int c;
    
    for(c=0;c<6;c++,cmd>>=1) clock_bit(cmd&1);
}

void write_data(int data)
{
    int c;
    
    data=(data&0x3FFF)<<1;
    
    for(c=0;c<16;c++,data>>=1) clock_bit(data&1);
}

int read_data()
{
    int c,data=0;
    
    set_pic_bit(DATA,1);
    for(c=0;c<16;c++)
    {
	set_pic_bit(CLOCK,1);
	small_delay();
	data=(data>>1)|(read_pic_data()?0x8000:0);
	set_pic_bit(CLOCK,0);
	small_delay();
    }
    return (data>>1)&0x3FFF;
}
