/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <string.h>
#include <unistd.h>
#include "mp84.h"

char filename[200];

int has_filename=0,do_unprotect=0,do_protect=0,do_read=0,do_write=0;
int do_identify=0,do_program_ids=0,do_verify=0,do_readstatus=0,do_writestatus=0;
int program_all=1,program_id=0,program_code=0,program_data=0,program_status=0;
int no_verify=0,be_quiet=0;

int parse_config(char *s)
{
    int c=0x3FF;
    if(sscanf(s,"%X",&c)==1)
    {
	conf_to_write=c&0xF;
	conf_mask=0xF;
    }
    else
    {
	// Here we would accept strings, eg. "FDSC_HS" or so...
	if(0)
	{
	}
	else return -1;
    }
}

int main(int argc,char *argv[])
{
    int c;
    char buf[100];
    
    write_message("PIC18F84 programmer (C) 2000 Michal Pleban",M_INFO);
    read_config();
    while((c=getopt(argc,argv,"PDISAsnqdhucp:r:v:i:o:"))!=EOF)
    {
	switch(c)
	{
	    case 'p' : strcpy(filename,optarg); has_filename=1; do_write=1; break;
	    case 'c' : do_protect=1; break;
	    case 'u' : do_unprotect=1; break;
	    case 'r' : strcpy(filename,optarg); has_filename=1; do_read=1; break;
	    case 'v' : strcpy(filename,optarg); has_filename=1; do_verify=1; break;
	    case 'o' : if(parse_config(optarg)<0)
		       { write_message("Invalid configuration word specification",M_ERROR); exit(1); }
		       else do_writestatus=1;
		       break;
	    case 'h' : dump_help(); exit(0); break;
	    case 'P' : program_all=0; program_code=1; break;
	    case 'D' : program_all=0; program_data=1; break;
	    case 'I' : program_all=0; program_id=1; break;
	    case 'S' : program_all=0; program_status=1; break;
	    case 'A' : program_all=1; break;
	    case 'd' : do_identify=1; break;
	    case 's' : do_readstatus=1; break;
	    case 'q' : be_quiet=1; break;
	    case 'n' : no_verify=1; break;
	    case 'i' : if(sscanf(optarg,"%X/%X/%X/%X",id,id+1,id+2,id+3)!=4)
		       { write_message("Invalid IDs",M_ERROR); exit(1); }
		       do_program_ids=1; break;
	    default  : write_message("Invalid option",M_ERROR); exit(1);
	}
    }
    if(!do_protect&&!do_unprotect&&!do_read&&!do_write&&!do_identify&&!do_program_ids&&!do_verify&&!do_readstatus&&!do_writestatus)
    {
	dump_help();
	exit(0);
    }
    if(program_all) program_code=program_data=program_id=program_status=1;
    if(ioperm(iobase,2,1))
    {
	write_message("Cannot access the IO ports",M_ERROR);
	exit(2);
    }
    ioperm(0x80,1,1);
    seek_for_programmer();
    if(!be_quiet)
    {
	write_message("Make sure no other program will attempt to write to your LPT port.",M_INFO);
	write_message("Then insert a chip into the programmer and press ENTER.",M_INFO_L);
	wait_for_enter();
    }
    set_voltage(NORMAL);
    clear_buffer();
    if(do_unprotect) unprotect_code();
    if(do_writestatus) write_status();
    if(do_program_ids) program_ids();
    if(do_write&&has_filename)
    {
	parse_file(filename);
	program_pic();
    }
    if(do_verify&&has_filename)
    {
	parse_file(filename);
	verify_pic();
    }
    if(do_read&&has_filename)
    {
	read_pic();
	write_file(filename);
    }
    if(do_identify) identify_chip();
    if(do_readstatus) read_status();
    if(do_protect) protect_code();
    set_voltage(NONE);
    if(!be_quiet)
    {
	write_message("Remove the chip from the programmer and press ENTER.",M_INFO_L);
	wait_for_enter();
    }
    ioperm(iobase,3,0);
    ioperm(0x80,1,0);
    return 0;
}
