/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include "mp84.h"

void write_message(char *msg,int code)
{
    char *heads[]={"Warning: ","","Error: "};
    FILE *f=stderr;
    
    if((code&0xFF)==M_INFO) f=stdout;
    fprintf(f,"%s%s%c",heads[code&0xFF],msg,(code&0x100)?' ':'\n');
    fflush(f);
}

void panic(int code)
{
    ioperm(iobase,3,0);
    ioperm(0x80,1,0);
    exit(code);
}

int used_area(int beg,int end)
{
    int used=0,tmp;
    
    for(tmp=beg;tmp<end;used|=(words[tmp++]&0x8000));
    return used;
}

void clear_buffer()
{
    int tmp;

    for(tmp=0;tmp<0x4000;words[tmp++]=0);
}


void dump_help()
{
    write_message(  "Usage:\n"
		    " -p file.hex\t\tProgram PIC16F84 chip with IHX file contents\n"
		    " -v file.hex\t\tVerify PIC16F84 chip with IHX file contents\n"
		    " -r file.hex\t\tRead PIC16F84 memory to IHX file\n"
		    " -c\t\t\tEnable code protection\n"
		    " -u\t\t\tDisable code protection\n"
		    " -i ID0/ID1/ID2/ID3\tProgram ID locations\n"
		    " -d\t\t\tRead ID locations\n"
		    " -P\t\t\tProgram only program memory\n"
		    " -D\t\t\tProgram only EEPROM data memory\n"
		    " -I\t\t\tProgram only ID locations\n"
		    " -S\t\t\tProgram only status word\n"
		    " -q\t\t\tOperate in \"quiet\" mode\n"
		    " -h\t\t\tDisplay this help message",M_INFO);
}

void wait_for_enter()
{
    while(getchar()!='\n');
}
