/******************************************************************************
    mp84 0.9.5 - PIC16F84 programmer controller with marginig support.
    Copyright (C) 2000 Michal Pleban <mpleban@elka.pw.edu.pl>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/

#include <stdio.h>

/*
 * Bit masks for setting/resetting particular bits on the chip
 */
#define DATA 16
#define CLOCK 8
#define MCLR 32

/*
 * Values for voltage selscting
  */
#define LOW 4
#define NORMAL 2
#define HIGH 0
#define NONE 1

/*
 * Commands for PIC in programming mode
 */
#define LOADCONF 0
#define LOADPROG 2
#define READPROG 4
#define INCREMENT 6
#define PROGRAM 8
#define LOADDATA 3
#define READDATA 5
#define BEPROG 9
#define BEDATA 11
#define UCP1 1
#define UCP2 7

/*
 * Message tyles for write_message()
 */
#define M_WARNING 0
#define M_INFO 1
#define M_ERROR 2
#define M_INFO_L 0x101

/*
 * Return codes form parse_line()
 */
#define F_CONTINUE 0
#define F_EOF 1
#define F_ERROR 2

/*
 * Error condition flag
 */
#define ERROR -1

/*
 * Name of the file to read/write
 */
extern char filename[200];

/*
 * Action(s) to take
 */
extern int has_filename,do_unprotect,do_protect,do_read,do_write,do_identify,do_program_ids,be_quiet,do_verify,do_readstatus;
extern int program_all,program_id,program_code,program_data,program_status;
extern int no_verify;

/*
 * ID values to program
 */
extern int id[4];
extern int conf_to_write,conf_mask;

/*
 * IO address for parallel port we're using
 */
extern int iobase;

/*
 * Contents of HEX file
 */
extern int words[0x4000];

/*
 * 
 */
extern int hascode,hasid,hasstatus,hasdata,hasmore;

/*
 * The io.c file - low-level IO routines
 */
void small_delay();  /* Do a delay between port accesses */
void set_lpt_bits(int value,int mask); /* Set or clear bits on LPT port with specified value and mask */
void set_voltage(int v); /* Set Vcc level for the chip */
void set_pic_bit(int bit,int v); /* Wrapper for set_lpt_bits */
int read_pic_data(); /* Read a BUSY pin value from LPT port */
void enter_prog_mode(); /* Reset the chip and go int programming mode */
void leave_prog_mode(); /* Terminate programming mode */
void clock_bit(int bit); /* Clock one bit to the chip using CLOCK and DATA lines */
void seek_for_programmer(); /* See whether the programmer is plugged in and turned on */
void issue_command(int cmd); /* Send a 6-bit command to the chip */
void write_data(int data); /* Send 16-bit data value to the chip */
int read_data(); /* Read 16-bit data value from the chip */

/*
 * The actions.c file - high-level procedures for programming or reading the chip data
 */
void read_status(); /* Read and print the configuration word */
void identify_chip(); /* Read four IDs from the chip */
void program_ids(); /* Write IDs to the chip */
void protect_code(); /* Enable code protection */
void unprotect_code(); /* Disable code protection */
void program_area(int base,int len,int command,int command2,int mask); /* Program the desired area of PIC memory with part of 'words' arrray */
void verify_area(int base,int len,int command,int mask); /* Verify area of PIC emmory */
void read_area(int base,int len,int command); /* Read area of PIC memory into 'words' array */
void read_pic(); /* Read the whole PIC memory */
void program_pic(); /* Program the whole PIC memory */
void verify_pic(); /* Verify the whole PIC memory */

/*
 * The file.c file - routines for reading and writing HEX files
 */
int hex_number(char *h); /* Return a decoded hexadecimal number or ERROR in case of error */
int check_line(char *l); /* Check if a line from HEX file has correct checksum */
int parse_line(FILE *f); /* Parse a line from HEX file */
void parse_file(char *name); /* Read the whole HEX file into 'words' array */
void write_line(FILE *f,int adr,int cnt,int *buf); /* Write one line to the HEX file */
void write_file(char *name); /* Write the whole 'words' array to the HEX file */

/*
 * The config.c file - routines for reading configuration files
 */
void parse_config_file(FILE *f); /* Parse the configuration file */
void read_config(); /* Read all possible cofiguration files */

/*
 * The misc.c file - miscelanneous routines
 */
void write_message(char *msg,int code); /* Write a message to stdout or stderr */
void panic(int code); /* Clean up and exit with return code */
int used_area(int beg,int end); /* Check whether specified area of 'woerds' array is used */
void clear_buffer(); /* Clear the 'words' array */
void dump_help(); /* Write help message */
void wait_for_enter(); /* Wait for pressing the ENTER key */

